<?php
require_once __DIR__ . '/../../src/config.php';
require_once __DIR__ . '/../../src/csrf.php';
require_once __DIR__ . '/../../src/layout.php';

require_login();
$user = current_user();
if ($user['user_type'] !== 'teacher') {
  http_response_code(403);
  echo 'Forbidden';
  exit;
}

$pdo = db();
$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_verify()) {
    $errors[] = 'Bad CSRF';
  } else {
    $paperId = (int)($_POST['paper_id'] ?? 0);
    if (isset($_POST['toggle_publish'])) {
      $stmt = $pdo->prepare('UPDATE papers SET is_published=1-is_published WHERE id=? AND teacher_id=?');
      $stmt->execute([$paperId, $user['id']]);
      $success = 'Toggled publish state.';
    }
  }
}

$stmt = $pdo->prepare('SELECT id,title,is_published,fee_cents,time_limit_seconds FROM papers WHERE teacher_id=? ORDER BY id DESC');
$stmt->execute([$user['id']]);
$papers = $stmt->fetchAll();
$publishedCount = count(array_filter($papers, fn($p) => $p['is_published']));
$draftCount = count($papers) - $publishedCount;

render_header('Manage Papers');
?>

<div class="app-content">
  <div class="container-xxl">
    <h1 class="mb-4">My Papers</h1>

    <!-- Alerts -->
    <?php foreach ($errors as $e): ?>
      <div class="alert alert-danger"><?= htmlspecialchars($e) ?></div>
    <?php endforeach; ?>
    <?php if ($success): ?>
      <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <!-- Stats Section -->
    <div class="row g-3 mb-4">
      <div class="col-md-4">
        <div class="app-card p-3">
          <p class="text-muted small mb-2">Total Papers</p>
          <h3 class="mb-0" style="color: #6759ff;"><?= count($papers) ?></h3>
        </div>
      </div>
      <div class="col-md-4">
        <div class="app-card p-3">
          <p class="text-muted small mb-2">Published</p>
          <h3 class="mb-0" style="color: #14b8a6;"><?= $publishedCount ?></h3>
        </div>
      </div>
      <div class="col-md-4">
        <div class="app-card p-3">
          <p class="text-muted small mb-2">Drafts</p>
          <h3 class="mb-0" style="color: #ff9800;"><?= $draftCount ?></h3>
        </div>
      </div>
    </div>

    <!-- Main Card -->
    <div class="app-card p-4">
      <div class="d-flex justify-content-between align-items-center mb-4">
        <h5 class="mb-0">Papers List</h5>
        <a href="new_paper.php" class="btn btn-sm btn-primary">Create New</a>
      </div>

      <?php if (empty($papers)): ?>
        <div class="text-center py-5" style="background-color: #f9f9f9; border-radius: 8px;">
          <p class="text-muted mb-3">No papers created yet. <a href="new_paper.php">Create one</a></p>
        </div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-sm">
            <thead>
              <tr>
                <th>ID</th>
                <th>Title</th>
                <th>Status</th>
                <th>Fee</th>
                <th>Duration</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($papers as $p): ?>
                <tr>
                  <td><?= $p['id'] ?></td>
                  <td><?= htmlspecialchars($p['title']) ?></td>
                  <td>
                    <?php if ($p['is_published']): ?>
                      <span class="badge bg-success">Published</span>
                    <?php else: ?>
                      <span class="badge bg-warning">Draft</span>
                    <?php endif; ?>
                  </td>
                  <td>
                    <?php if ($p['fee_cents'] > 0): ?>
                      Rs. <?= number_format($p['fee_cents'] / 100, 2) ?>
                    <?php else: ?>
                      Free
                    <?php endif; ?>
                  </td>
                  <td><?= intval($p['time_limit_seconds'] / 60) ?> min</td>
                  <td>
                    <form method="post" class="d-inline">
                      <?= csrf_field(); ?>
                      <input type="hidden" name="paper_id" value="<?= $p['id'] ?>">
                      <button name="toggle_publish" class="btn btn-xs btn-outline-primary">
                        <?= $p['is_published'] ? 'Unpub' : 'Pub' ?>
                      </button>
                    </form>
                    <a class="btn btn-xs btn-outline-primary" href="<?= htmlspecialchars(app_href('teacher/edit_paper.php?paper_id=' . $p['id'])) ?>">Edit</a>
                    <a class="btn btn-xs btn-outline-primary" href="<?= htmlspecialchars(app_href('teacher/assign.php?paper_id=' . $p['id'])) ?>">Assign</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>

<?php render_footer(); ?>
