<?php
require_once __DIR__ . '/../../src/config.php';
require_once __DIR__ . '/../../src/layout.php';
require_login();
$user = current_user();
if ($user['user_type'] !== 'student') { http_response_code(403); echo 'Forbidden'; exit; }
$pdo = db();
$sql = "SELECT p.id, p.title, p.fee_cents, p.time_limit_seconds, u.name AS teacher_name,
        EXISTS(SELECT 1 FROM payments pay WHERE pay.paper_id=p.id AND pay.user_id=? AND pay.status='completed') AS paid
        FROM papers p
        JOIN users u ON p.teacher_id = u.id
        JOIN teacher_student ts ON ts.teacher_id = p.teacher_id AND ts.student_id = ?
        WHERE p.is_published=1";
$stmt = $pdo->prepare($sql);
$stmt->execute([$user['id'], $user['id']]);
$papers = $stmt->fetchAll();
$totalPapers = count($papers);
$freePapers = count(array_filter($papers, fn($p) => (int)$p['fee_cents'] === 0));
$paidUnlocked = count(array_filter($papers, fn($p) => $p['fee_cents'] > 0 && $p['paid']));
render_header('Available Papers');
?>

<!-- Hero Section -->
<section style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); border-radius: 12px; padding: 3rem; color: white; margin-bottom: 3rem; position: relative; overflow: hidden;">
  <div style="position: absolute; top: 0; right: 0; font-size: 8rem; opacity: 0.1;">
    <i class="bi bi-file-earmark-text"></i>
  </div>
  <div class="position-relative">
    <h1 class="mb-2" style="font-size: 2.5rem; font-weight: 700;">
      <i class="bi bi-file-earmark-text me-2"></i>Available Papers
    </h1>
    <p style="opacity: 0.95; font-size: 1.1rem; margin: 0;">Explore papers from your mapped teachers</p>
  </div>
</section>

<!-- Stats Cards -->
<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin-bottom: 3rem;">
  <!-- Total Papers Card -->
  <div style="background: white; border-radius: 12px; padding: 1.5rem; box-shadow: 0 2px 8px rgba(0,0,0,0.08); border-left: 4px solid #667eea;">
    <div style="display: flex; align-items: flex-start; justify-content: space-between; gap: 1rem;">
      <div style="flex: 1;">
        <p style="margin: 0 0 0.5rem 0; color: #999; font-size: 0.9rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">Total Papers</p>
        <p style="margin: 0; font-weight: 700; color: #667eea; font-size: 2rem;"><?= $totalPapers ?></p>
        <p style="margin: 0.5rem 0 0 0; color: #666; font-size: 0.85rem;">Published by your teachers</p>
      </div>
      <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.8rem; flex-shrink: 0;">
        <i class="bi bi-file-earmark"></i>
      </div>
    </div>
  </div>

  <!-- Free Papers Card -->
  <div style="background: white; border-radius: 12px; padding: 1.5rem; box-shadow: 0 2px 8px rgba(0,0,0,0.08); border-left: 4px solid #00d084;">
    <div style="display: flex; align-items: flex-start; justify-content: space-between; gap: 1rem;">
      <div style="flex: 1;">
        <p style="margin: 0 0 0.5rem 0; color: #999; font-size: 0.9rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">Free Attempts</p>
        <p style="margin: 0; font-weight: 700; color: #00d084; font-size: 2rem;"><?= $freePapers ?></p>
        <p style="margin: 0.5rem 0 0 0; color: #666; font-size: 0.85rem;">Start without payment</p>
      </div>
      <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #00d084 0%, #13c084 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.8rem; flex-shrink: 0;">
        <i class="bi bi-check-circle-fill"></i>
      </div>
    </div>
  </div>

  <!-- Paid & Unlocked Card -->
  <div style="background: white; border-radius: 12px; padding: 1.5rem; box-shadow: 0 2px 8px rgba(0,0,0,0.08); border-left: 4px solid #ffc107;">
    <div style="display: flex; align-items: flex-start; justify-content: space-between; gap: 1rem;">
      <div style="flex: 1;">
        <p style="margin: 0 0 0.5rem 0; color: #999; font-size: 0.9rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">Unlocked Paid</p>
        <p style="margin: 0; font-weight: 700; color: #ffc107; font-size: 2rem;"><?= $paidUnlocked ?></p>
        <p style="margin: 0.5rem 0 0 0; color: #666; font-size: 0.85rem;">Already paid & ready</p>
      </div>
      <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%); border-radius: 12px; display: flex; align-items: center; justify-content: center; color: white; font-size: 1.8rem; flex-shrink: 0;">
        <i class="bi bi-lock-fill"></i>
      </div>
    </div>
  </div>
</div>

<!-- Papers List Section -->
<section style="background: white; border-radius: 12px; padding: 0; box-shadow: 0 2px 8px rgba(0,0,0,0.08); overflow: hidden;">
  <div style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); padding: 1.5rem; color: white; border-bottom: 4px solid #4facfe;">
    <h2 class="h5 mb-0 d-flex align-items-center gap-2" style="font-weight: 700;">
      <i class="bi bi-list-ul" style="font-size: 1.3rem;"></i>All Papers
    </h2>
  </div>
  <div style="padding: 1.5rem;">
    <?php if (empty($papers)): ?>
      <div style="text-align: center; padding: 3rem 1rem;">
        <i class="bi bi-inbox" style="font-size: 3rem; color: #999; display: block; margin-bottom: 1rem;"></i>
        <p style="color: #999; font-size: 1.1rem; margin: 0;">No papers available yet.</p>
        <p style="color: #ccc; font-size: 0.9rem; margin: 0.5rem 0 0 0;">Only teachers linked to you can publish here.</p>
      </div>
    <?php else: ?>
      <div style="display: flex; flex-direction: column; gap: 1rem;">
        <?php foreach ($papers as $p): 
          $isFree = $p['fee_cents'] == 0;
          $isPaid = $p['paid'];
          $isAccessible = $isFree || $isPaid;
          $borderColor = $isAccessible ? '#00d084' : '#ffc107';
          $bgColor = $isAccessible ? '#f0fdf4' : '#fffbf0';
        ?>
          <div style="padding: 1.5rem; background: <?= $bgColor ?>; border: 2px solid <?= $borderColor ?>; border-radius: 10px; transition: all 0.2s;"
               onmouseover="this.style.boxShadow='0 4px 12px rgba(0,0,0,0.1)'; this.style.transform='translateY(-2px)';"
               onmouseout="this.style.boxShadow='none'; this.style.transform='translateY(0)';">
            <div class="d-flex justify-content-between align-items-start gap-2">
              <div style="flex: 1;">
                <p style="margin: 0 0 0.5rem 0; font-weight: 700; color: #333; font-size: 1.1rem;">
                  <i class="bi bi-file-earmark-text me-2" style="color: #4facfe;"></i><?= htmlspecialchars($p['title']) ?>
                </p>
                <p style="margin: 0 0 0.5rem 0; color: #666; font-size: 0.9rem;">
                  <i class="bi bi-person me-1" style="color: #667eea;"></i><?= htmlspecialchars($p['teacher_name']) ?>
                </p>
                <div style="display: flex; gap: 1.5rem; flex-wrap: wrap;">
                  <p style="margin: 0; color: #666; font-size: 0.9rem;">
                    <i class="bi bi-hourglass-split me-1" style="color: #ffc107;"></i><?= intval($p['time_limit_seconds'] / 60) ?> minutes
                  </p>
                  <p style="margin: 0; color: #666; font-size: 0.9rem;">
                    <i class="bi bi-tag me-1" style="color: #f5576c;"></i>
                    <?php if ($isFree): ?>
                      <span style="color: #00d084; font-weight: 600;">Free</span>
                    <?php elseif ($isPaid): ?>
                      <span style="color: #4facfe; font-weight: 600;">✓ Unlocked</span>
                    <?php else: ?>
                      <span style="color: #ffc107; font-weight: 600;"><?= number_format($p['fee_cents']) ?> cents</span>
                    <?php endif; ?>
                  </p>
                </div>
              </div>
              <div style="text-align: right; flex-shrink: 0;">
                <?php if ($isAccessible): ?>
                  <a class="btn btn-sm" style="background: linear-gradient(135deg, #00d084 0%, #13c084 100%); color: white; border: none; font-weight: 600; white-space: nowrap;" href="<?= htmlspecialchars(app_href('student/attempt.php?paper_id=' . $p['id'])) ?>">
                    <i class="bi bi-play-fill"></i> Start
                  </a>
                <?php else: ?>
                  <form method="post" action="<?= htmlspecialchars(app_href('student/pay.php')) ?>" class="d-inline">
                    <input type="hidden" name="paper_id" value="<?= $p['id'] ?>">
                    <button type="submit" class="btn btn-sm" style="background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%); color: white; border: none; font-weight: 600; white-space: nowrap;">
                      <i class="bi bi-credit-card"></i> Pay
                    </button>
                  </form>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</section>
<?php render_footer(); ?>